
#This has to do with the following bioassays
# Beetroot - Pythium                          # bee
# Onion - Fusarium                            # oni2
# Spinach - Pythium                           # spi1
# Coriander - Pythium                         # cor
# Pepper - Phytophthora capsici SEEDS         # pep2 / pepperSeeds

# import data and source code -------------------------------------------------------------
#need to set working directory
#setwd()
source('summarySE_function.R')
source("02 data analysis.R") #the output of that script is full_summary2
all_data <- full_summary2

#continuous data
beetroot <- read.csv("Beetroot4R_data.csv")
onion <- read.csv("Onion4R_data.csv")
spinach <- read.csv("Spinach4R_data.csv")
coriander <- read.csv("Coriander4R_data.csv")
pepperSeeds <- read.csv('Pepper_seeds_4Rdata.csv')

# packages ----------------------------------------------------------------
# library(ggplot2)
# library(tidyverse)
# library(ggpubr)
# library(ggrepel)
# 
# library("gridExtra")
# library("cowplot")
# library(ggtext)
# library(grid)

# adjust dataframe  ----------------------------------------------------------------
# beetroot   -----------------------------------------------------------------------
#var1 - Inf_pre
#var2 - Inf_post
# beetroot var1  -------------------------------------------------------------------
beetrootSE <- summarySE(beetroot, measurevar="Inf_pre", groupvars=c("SeedLot","MRTrt"))
beetroot_untrt <- beetrootSE[beetrootSE$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
beetroot_trt <- beetrootSE[beetrootSE$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
beetroot_sep <- cbind(beetroot_untrt, beetroot_trt)
beetroot_sep$SeedLot <- as.character(beetroot_sep$SeedLot_trt)
beetroot_sep$Variable_1 <- all_data$Bio_var1[which(all_data$BioassayType=='Beetroot_Pythium')]
beetroot_sep$Ger_energy <- all_data$Ger_energy[which(all_data$BioassayType=='Beetroot_Pythium')]
beetroot_sep$Ger_capacity <- all_data$Ger_capacity[which(all_data$BioassayType=='Beetroot_Pythium')]
beetroot_sep2 <- beetroot_sep[which((beetroot_sep$Ger_energy != "affected") & (beetroot_sep$Ger_capacity != "affected")),]

b1 <- ggplot(beetroot_sep2, aes(x=Inf_pre_untrt, y=Inf_pre_trt, colour=Variable_1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="A1. Beetroot -"~italic(P.)~~italic(ultimum)~" ",
       subtitle = "Pre-emergence d.o. (%)",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)")


# beetroot var2  -------------------------------------------------------------------
beetrootSE <- summarySE(beetroot, measurevar="Inf_post", groupvars=c("SeedLot","MRTrt"))
beetroot_untrt <- beetrootSE[beetrootSE$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
beetroot_trt <- beetrootSE[beetrootSE$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
beetroot_sep <- cbind(beetroot_untrt, beetroot_trt)
beetroot_sep$SeedLot <- as.character(beetroot_sep$SeedLot_trt)
beetroot_sep$Variable_2 <- all_data$Bio_var2[which(all_data$BioassayType=='Beetroot_Pythium')]
beetroot_sep$Ger_energy <- all_data$Ger_energy[which(all_data$BioassayType=='Beetroot_Pythium')]
beetroot_sep$Ger_capacity <- all_data$Ger_capacity[which(all_data$BioassayType=='Beetroot_Pythium')]
beetroot_sep2 <- beetroot_sep[which((beetroot_sep$Ger_energy != "affected") & (beetroot_sep$Ger_capacity != "affected")),]

b2 <- ggplot(beetroot_sep2, aes(x=Inf_post_untrt, y=Inf_post_trt, colour=Variable_2)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11),
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="A2. Beetroot -"~italic(P.)~~italic(ultimum)~" ",
       subtitle = "Post-emergence d.o. (%)",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)")

#
#
#
#
#
#
# onion   -----------------------------------------------------------------------
#var1 - Inf_pre_13
#var2 - Inf_post_13
# onion var1  -------------------------------------------------------------------
onionSE <- summarySE(onion, measurevar="Inf_pre_13", groupvars=c("SeedLot","MRTrt"))
onion_untrt <- onionSE[onionSE$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
onion_trt <- onionSE[onionSE$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
onion_sep <- cbind(onion_untrt, onion_trt)
onion_sep$SeedLot <- as.character(onion_sep$SeedLot_trt)
onion_sep$Variable_1 <- all_data$Bio_var1[which(all_data$BioassayType=='Onion_Fusarium')]
onion_sep$Ger_energy <- all_data$Ger_energy[which(all_data$BioassayType=='Onion_Fusarium')]
onion_sep$Ger_capacity <- all_data$Ger_capacity[which(all_data$BioassayType=='Onion_Fusarium')]
onion_sep2 <- onion_sep[which((onion_sep$Ger_energy != "affected") & (onion_sep$Ger_capacity != "affected")),]

o1 <- ggplot(onion_sep2, aes(x=Inf_pre_13_untrt, y=Inf_pre_13_trt, colour=Variable_1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="C1. Onion -"~italic(F.)~~italic(oxysporum)~" ",
       subtitle = "Pre-emergence d.o. (%)",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)")


# onion var2  -------------------------------------------------------------------
onionSE <- summarySE(onion, measurevar="Inf_post_13", groupvars=c("SeedLot","MRTrt"))
onion_untrt <- onionSE[onionSE$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
onion_trt <- onionSE[onionSE$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
onion_sep <- cbind(onion_untrt, onion_trt)
onion_sep$SeedLot <- as.character(onion_sep$SeedLot_trt)
onion_sep$Variable_2 <- all_data$Bio_var2[which(all_data$BioassayType=='Onion_Fusarium')]
onion_sep$Ger_energy <- all_data$Ger_energy[which(all_data$BioassayType=='Onion_Fusarium')]
onion_sep$Ger_capacity <- all_data$Ger_capacity[which(all_data$BioassayType=='Onion_Fusarium')]
onion_sep2 <- onion_sep[which((onion_sep$Ger_energy != "affected") & (onion_sep$Ger_capacity != "affected")),]

o2 <- ggplot(onion_sep2, aes(x=Inf_post_13_untrt, y=Inf_post_13_trt, colour=Variable_2)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="C2. Onion -"~italic(F.)~~italic(oxysporum)~" ",
       subtitle = "Post-emergence d.o. (%)",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)")
#
#
#
#
#
#
# spinach  -------------------------------------------------------------------
#correct for FDR
all_data$Bio_var1[which(
  all_data$SeedLot %in% c(325, 337)&
    all_data$BioassayType %in% 
    c('Spinach_Pythium'))] <- 'Non-responsive seed lots'

#var1 - 100-Emerge_fin    
#var2 - Inf_post
head(spinach)
spinach$Inf_pre <- 100*(63 - spinach$Emerge_count_fin)/63
spinach$Inf_post <- 100*(spinach$Inf_count_post)/63

# spinach var1  -------------------------------------------------------------------
spinachSE <- summarySE(spinach, measurevar="Inf_pre", groupvars=c("SeedLot","MRTrt"))
spinach_untrt <- spinachSE[spinachSE$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
spinach_trt <- spinachSE[spinachSE$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
spinach_sep <- cbind(spinach_untrt, spinach_trt)
spinach_sep$SeedLot <- as.character(spinach_sep$SeedLot_trt)
spinach_sep$Variable_1 <- all_data$Bio_var1[which(all_data$BioassayType=='Spinach_Pythium')]
spinach_sep$Ger_energy <- all_data$Ger_energy[which(all_data$BioassayType=='Spinach_Pythium')]
spinach_sep$Ger_capacity <- all_data$Ger_capacity[which(all_data$BioassayType=='Spinach_Pythium')]
spinach_sep2 <- spinach_sep[which((spinach_sep$Ger_energy != "affected") & (spinach_sep$Ger_capacity != "affected")),]

s1 <- ggplot(spinach_sep2, aes(x=Inf_pre_untrt, y=Inf_pre_trt, colour=Variable_1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="D1. Spinach -"~italic(P.)~~italic(ultimum)~" ",
       subtitle = "Pre-emergence d.o. (%)",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)")


# spinach var2  -------------------------------------------------------------------
spinachSE <- summarySE(spinach, measurevar="Inf_post", groupvars=c("SeedLot","MRTrt"))
spinach_untrt <- spinachSE[spinachSE$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
spinach_trt <- spinachSE[spinachSE$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
spinach_sep <- cbind(spinach_untrt, spinach_trt)
spinach_sep$SeedLot <- as.character(spinach_sep$SeedLot_trt)
spinach_sep$Variable_2 <- all_data$Bio_var2[which(all_data$BioassayType=='Spinach_Pythium')]
spinach_sep$Ger_energy <- all_data$Ger_energy[which(all_data$BioassayType=='Spinach_Pythium')]
spinach_sep$Ger_capacity <- all_data$Ger_capacity[which(all_data$BioassayType=='Spinach_Pythium')]
spinach_sep2 <- spinach_sep[which((spinach_sep$Ger_energy != "affected") & (spinach_sep$Ger_capacity != "affected")),]


s2 <- ggplot(spinach_sep2, aes(x=Inf_post_untrt, y=Inf_post_trt, colour=Variable_2)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="D2. Spinach -"~italic(P.)~~italic(ultimum)~" ",
       subtitle = "Post-emergence d.o. (%)",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)")
#
#
#
#
#
#
# coriander  -------------------------------------------------------------------
#var1 - 100-total_emerge2    
#var2 - Inf_post2
head(coriander)
coriander$Inf_pre <- 100 - coriander$total_emerge2

# coriander var1  -------------------------------------------------------------------
corianderSE <- summarySE(coriander, measurevar="Inf_pre", groupvars=c("SeedLot","MRTrt"))
coriander_untrt <- corianderSE[corianderSE$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
coriander_trt <- corianderSE[corianderSE$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
coriander_sep <- cbind(coriander_untrt, coriander_trt)
coriander_sep$SeedLot <- as.character(coriander_sep$SeedLot_trt)
coriander_sep$Variable_1 <- all_data$Bio_var1[which(all_data$BioassayType=='Coriander_Pythium')]
coriander_sep$Ger_energy <- all_data$Ger_energy[which(all_data$BioassayType=='Coriander_Pythium')]
coriander_sep$Ger_capacity <- all_data$Ger_capacity[which(all_data$BioassayType=='Coriander_Pythium')]
coriander_sep2 <- coriander_sep[which((coriander_sep$Ger_energy != "affected") & (coriander_sep$Ger_capacity != "affected")),]

c1 <- ggplot(coriander_sep2, aes(x=Inf_pre_untrt, y=Inf_pre_trt, colour=Variable_1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="F1. Coriander -"~italic(Pythium)~" sp.",
       subtitle = "Pre-emergence d.o. (%)",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)")


# coriander var2  -------------------------------------------------------------------
corianderSE <- summarySE(coriander, measurevar="Inf_post2", groupvars=c("SeedLot","MRTrt"))
coriander_untrt <- corianderSE[corianderSE$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
coriander_trt <- corianderSE[corianderSE$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
coriander_sep <- cbind(coriander_untrt, coriander_trt)
coriander_sep$SeedLot <- as.character(coriander_sep$SeedLot_trt)
coriander_sep$Variable_2 <- all_data$Bio_var2[which(all_data$BioassayType=='Coriander_Pythium')]
coriander_sep$Ger_energy <- all_data$Ger_energy[which(all_data$BioassayType=='Coriander_Pythium')]
coriander_sep$Ger_capacity <- all_data$Ger_capacity[which(all_data$BioassayType=='Coriander_Pythium')]
coriander_sep2 <- coriander_sep[which((coriander_sep$Ger_energy != "affected") & (coriander_sep$Ger_capacity != "affected")),]


c2 <- ggplot(coriander_sep2, aes(x=Inf_post2_untrt, y=Inf_post2_trt, colour=Variable_2)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="F2. Coriander -"~italic(Pythium)~" sp.",
       subtitle = "Post-emergence d.o. (%)",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)")
#
#
#
#
#
#
# pepperSeeds  -------------------------------------------------------------------
#var1 - Ev3_missing    
#var2 - Ev3_dead
head(pepperSeeds)
pepperSeeds$Inf_pre <-  pepperSeeds$Ev3_missing / 8 *100
pepperSeeds$Inf_post <- pepperSeeds$Ev3_dead / 8 *100


# pepperSeeds var1  -------------------------------------------------------------------
pepperSeedsSE <- summarySE(pepperSeeds, measurevar="Inf_pre", groupvars=c("SeedLot","MRTrt"))
pepperSeeds_untrt <- pepperSeedsSE[pepperSeedsSE$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
pepperSeeds_trt <- pepperSeedsSE[pepperSeedsSE$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
pepperSeeds_sep <- cbind(pepperSeeds_untrt, pepperSeeds_trt)
pepperSeeds_sep$SeedLot <- as.character(pepperSeeds_sep$SeedLot_trt)
pepperSeeds_sep$Variable_1 <- all_data$Bio_var1[which(all_data$BioassayType=='Pepper seeds_Phytophthora capsici')]
pepperSeeds_sep$Ger_energy <- all_data$Ger_energy[which(all_data$BioassayType=='Pepper seeds_Phytophthora capsici')]
pepperSeeds_sep$Ger_capacity <- all_data$Ger_capacity[which(all_data$BioassayType=='Pepper seeds_Phytophthora capsici')]
pepperSeeds_sep2 <- pepperSeeds_sep[which((pepperSeeds_sep$Ger_energy != "affected") & (pepperSeeds_sep$Ger_capacity != "affected")),]

p1 <- ggplot(pepperSeeds_sep2, aes(x=Inf_pre_untrt, y=Inf_pre_trt, colour=Variable_1)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="H1. Pepper -"~italic(P.)~~italic(capsici)~" ",
       subtitle = "Seedlings; pre-emergence d.o.",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)")

# pepperSeeds var2  -------------------------------------------------------------------
pepperSeedsSE <- summarySE(pepperSeeds, measurevar="Inf_post", groupvars=c("SeedLot","MRTrt"))
pepperSeeds_untrt <- pepperSeedsSE[pepperSeedsSE$MRTrt == 'untrt',]%>% rename_all(paste0, "_untrt")
pepperSeeds_trt <- pepperSeedsSE[pepperSeedsSE$MRTrt == 'trt',]%>% rename_all(paste0, "_trt")
pepperSeeds_sep <- cbind(pepperSeeds_untrt, pepperSeeds_trt)
pepperSeeds_sep$SeedLot <- as.character(pepperSeeds_sep$SeedLot_trt)
pepperSeeds_sep$Variable_2 <- all_data$Bio_var2[which(all_data$BioassayType=='Pepper seeds_Phytophthora capsici')]
pepperSeeds_sep$Ger_energy <- all_data$Ger_energy[which(all_data$BioassayType=='Pepper seeds_Phytophthora capsici')]
pepperSeeds_sep$Ger_capacity <- all_data$Ger_capacity[which(all_data$BioassayType=='Pepper seeds_Phytophthora capsici')]
pepperSeeds_sep2 <- pepperSeeds_sep[which((pepperSeeds_sep$Ger_energy != "affected") & (pepperSeeds_sep$Ger_capacity != "affected")),]


p2 <- ggplot(pepperSeeds_sep2, aes(x=Inf_post_untrt, y=Inf_post_trt, colour=Variable_2)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07")) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="H2. Pepper -"~italic(P.)~~italic(capsici)~" ",
       subtitle = "Dead seedlings (%)",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)")
#
#
#
#
#
#
# legend -------------------------------------------------------------------
forLeg <- ggplot(pepperSeeds_sep2, aes(x=Inf_post_untrt, y=Inf_post_trt, colour=Variable_2)) + 
  geom_abline(intercept = 0, slope = 1, colour = 'grey36', 
              linetype="dotted")  +
  geom_point(alpha=0.6, size = 2, stroke = 1) +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"),
                     labels = c('Positively responsive seed lots',
                                'Non-responsive seed lots', 
                                'Negatively responsive seed lots')) + 
  theme_bw() + theme_classic() + 
  coord_cartesian(ylim = c(0, 100), xlim = c(0,100)) +
  theme(legend.position='none', plot.title = element_text(size=11), plot.subtitle = element_text(size=11), 
        axis.text.x = element_text(size = 9.5), axis.text.y = element_text(size = 9.5), 
        axis.title.x = element_text(size = 10.5), axis.title.y = element_text(size = 10.5)) + 
  labs(title="Pepper - "~italic(P.)~~italic(capsici)~"dead seedlings (%)",
       y="Disinfected seeds (mean)", 
       x="Non-treated seeds (mean)") +
  theme(legend.position=c(0.5,0.5), legend.title = element_blank(),
        legend.text = element_text(size=11))

legend <- get_legend(forLeg)


# graphs for Figure 3 -------------------------------------------------------------------
#the format used is the following:
#all graphs in two pages; first page 12 graphs; 
#second 8 graphs with space for the legend

plot_grid(b1, on1, o1,
          b2, on2, o2,
          s1, sp1, c1,
          s2, sp2, c2,
          ncol=3, 
          rel_widths = c(0.85, 0.80, 0.85,
                          0.85, 0.80, 0.85,
                          0.85, 0.80, 0.85,
                          0.85, 0.80, 0.85))

plot_grid(pe1, p1, fes1,
          pe2, p2, perth1,
          perpu1, legend,
          ncol=3)
#save as PDF size: A4
#12 graphs 8.27 x 11.69 inches
#8 graphs  8.27 x 8.77 inches
